/* $NetBSD: syscallargs.h,v 1.157 2006/10/17 15:07:21 christos Exp $ */

/*
 * System call argument lists.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.160 2006/10/17 15:06:18 christos Exp
 */

#ifndef _SYS_SYSCALLARGS_H_
#define	_SYS_SYSCALLARGS_H_

#ifdef	syscallarg
#undef	syscallarg
#endif

#define	syscallarg(x)							\
	union {								\
		register_t pad;						\
		struct { x datum; } le;					\
		struct { /* LINTED zero array dimension */		\
			int8_t pad[  /* CONSTCOND */			\
				(sizeof (register_t) < sizeof (x))	\
				? 0					\
				: sizeof (register_t) - sizeof (x)];	\
			x datum;					\
		} be;							\
	}

struct sys_exit_args {
	syscallarg(int) rval;
};

struct sys_read_args {
	syscallarg(int) fd;
	syscallarg(void *) buf;
	syscallarg(size_t) nbyte;
};

struct sys_write_args {
	syscallarg(int) fd;
	syscallarg(const void *) buf;
	syscallarg(size_t) nbyte;
};

struct sys_open_args {
	syscallarg(const char *) path;
	syscallarg(int) flags;
	syscallarg(mode_t) mode;
};

struct sys_close_args {
	syscallarg(int) fd;
};

struct sys_wait4_args {
	syscallarg(int) pid;
	syscallarg(int *) status;
	syscallarg(int) options;
	syscallarg(struct rusage *) rusage;
};

struct compat_43_sys_creat_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};

struct sys_link_args {
	syscallarg(const char *) path;
	syscallarg(const char *) link;
};

struct sys_unlink_args {
	syscallarg(const char *) path;
};

struct sys_chdir_args {
	syscallarg(const char *) path;
};

struct sys_fchdir_args {
	syscallarg(int) fd;
};

struct sys_mknod_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
	syscallarg(dev_t) dev;
};

struct sys_chmod_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};

struct sys_chown_args {
	syscallarg(const char *) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct sys_obreak_args {
	syscallarg(char *) nsize;
};

struct compat_20_sys_getfsstat_args {
	syscallarg(struct statfs12 *) buf;
	syscallarg(long) bufsize;
	syscallarg(int) flags;
};

struct compat_43_sys_lseek_args {
	syscallarg(int) fd;
	syscallarg(long) offset;
	syscallarg(int) whence;
};
#ifdef COMPAT_43
#else
#endif

struct sys_mount_args {
	syscallarg(const char *) type;
	syscallarg(const char *) path;
	syscallarg(int) flags;
	syscallarg(void *) data;
};

struct sys_unmount_args {
	syscallarg(const char *) path;
	syscallarg(int) flags;
};

struct sys_setuid_args {
	syscallarg(uid_t) uid;
};
#ifdef COMPAT_43
#else
#endif

struct sys_ptrace_args {
	syscallarg(int) req;
	syscallarg(pid_t) pid;
	syscallarg(caddr_t) addr;
	syscallarg(int) data;
};

struct sys_recvmsg_args {
	syscallarg(int) s;
	syscallarg(struct msghdr *) msg;
	syscallarg(int) flags;
};

struct sys_sendmsg_args {
	syscallarg(int) s;
	syscallarg(const struct msghdr *) msg;
	syscallarg(int) flags;
};

struct sys_recvfrom_args {
	syscallarg(int) s;
	syscallarg(void *) buf;
	syscallarg(size_t) len;
	syscallarg(int) flags;
	syscallarg(struct sockaddr *) from;
	syscallarg(unsigned int *) fromlenaddr;
};

struct sys_accept_args {
	syscallarg(int) s;
	syscallarg(struct sockaddr *) name;
	syscallarg(unsigned int *) anamelen;
};

struct sys_getpeername_args {
	syscallarg(int) fdes;
	syscallarg(struct sockaddr *) asa;
	syscallarg(unsigned int *) alen;
};

struct sys_getsockname_args {
	syscallarg(int) fdes;
	syscallarg(struct sockaddr *) asa;
	syscallarg(unsigned int *) alen;
};

struct sys_access_args {
	syscallarg(const char *) path;
	syscallarg(int) flags;
};

struct sys_chflags_args {
	syscallarg(const char *) path;
	syscallarg(u_long) flags;
};

struct sys_fchflags_args {
	syscallarg(int) fd;
	syscallarg(u_long) flags;
};

struct sys_kill_args {
	syscallarg(int) pid;
	syscallarg(int) signum;
};

struct compat_43_sys_stat_args {
	syscallarg(const char *) path;
	syscallarg(struct stat43 *) ub;
};

struct compat_43_sys_lstat_args {
	syscallarg(const char *) path;
	syscallarg(struct stat43 *) ub;
};

struct sys_dup_args {
	syscallarg(int) fd;
};

struct sys_profil_args {
	syscallarg(caddr_t) samples;
	syscallarg(size_t) size;
	syscallarg(u_long) offset;
	syscallarg(u_int) scale;
};
#if defined(KTRACE) || !defined(_KERNEL)

struct sys_ktrace_args {
	syscallarg(const char *) fname;
	syscallarg(int) ops;
	syscallarg(int) facs;
	syscallarg(int) pid;
};
#else
#endif

struct compat_13_sys_sigaction_args {
	syscallarg(int) signum;
	syscallarg(const struct sigaction13 *) nsa;
	syscallarg(struct sigaction13 *) osa;
};
#ifdef COMPAT_43
#else
#endif

struct compat_13_sys_sigprocmask_args {
	syscallarg(int) how;
	syscallarg(int) mask;
};

struct sys___getlogin_args {
	syscallarg(char *) namebuf;
	syscallarg(size_t) namelen;
};

struct sys___setlogin_args {
	syscallarg(const char *) namebuf;
};

struct sys_acct_args {
	syscallarg(const char *) path;
};

struct compat_13_sys_sigaltstack_args {
	syscallarg(const struct sigaltstack13 *) nss;
	syscallarg(struct sigaltstack13 *) oss;
};

struct sys_ioctl_args {
	syscallarg(int) fd;
	syscallarg(u_long) com;
	syscallarg(void *) data;
};

struct compat_12_sys_reboot_args {
	syscallarg(int) opt;
};

struct sys_revoke_args {
	syscallarg(const char *) path;
};

struct sys_symlink_args {
	syscallarg(const char *) path;
	syscallarg(const char *) link;
};

struct sys_readlink_args {
	syscallarg(const char *) path;
	syscallarg(char *) buf;
	syscallarg(size_t) count;
};

struct sys_execve_args {
	syscallarg(const char *) path;
	syscallarg(char *const *) argp;
	syscallarg(char *const *) envp;
};

struct sys_umask_args {
	syscallarg(mode_t) newmask;
};

struct sys_chroot_args {
	syscallarg(const char *) path;
};

struct compat_43_sys_fstat_args {
	syscallarg(int) fd;
	syscallarg(struct stat43 *) sb;
};

struct compat_43_sys_getkerninfo_args {
	syscallarg(int) op;
	syscallarg(char *) where;
	syscallarg(int *) size;
	syscallarg(int) arg;
};

struct compat_12_sys_msync_args {
	syscallarg(caddr_t) addr;
	syscallarg(size_t) len;
};

struct sys_sbrk_args {
	syscallarg(intptr_t) incr;
};

struct sys_sstk_args {
	syscallarg(int) incr;
};

struct compat_43_sys_mmap_args {
	syscallarg(caddr_t) addr;
	syscallarg(size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(long) pos;
};

struct sys_ovadvise_args {
	syscallarg(int) anom;
};

struct sys_munmap_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
};

struct sys_mprotect_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) prot;
};

struct sys_madvise_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) behav;
};

struct sys_mincore_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(char *) vec;
};

struct sys_getgroups_args {
	syscallarg(int) gidsetsize;
	syscallarg(gid_t *) gidset;
};

struct sys_setgroups_args {
	syscallarg(int) gidsetsize;
	syscallarg(const gid_t *) gidset;
};

struct sys_setpgid_args {
	syscallarg(int) pid;
	syscallarg(int) pgid;
};

struct sys_setitimer_args {
	syscallarg(int) which;
	syscallarg(const struct itimerval *) itv;
	syscallarg(struct itimerval *) oitv;
};

struct compat_12_sys_swapon_args {
	syscallarg(const char *) name;
};

struct sys_getitimer_args {
	syscallarg(int) which;
	syscallarg(struct itimerval *) itv;
};

struct compat_43_sys_gethostname_args {
	syscallarg(char *) hostname;
	syscallarg(u_int) len;
};

struct compat_43_sys_sethostname_args {
	syscallarg(char *) hostname;
	syscallarg(u_int) len;
};

struct sys_dup2_args {
	syscallarg(int) from;
	syscallarg(int) to;
};

struct sys_fcntl_args {
	syscallarg(int) fd;
	syscallarg(int) cmd;
	syscallarg(void *) arg;
};

struct sys_select_args {
	syscallarg(int) nd;
	syscallarg(fd_set *) in;
	syscallarg(fd_set *) ou;
	syscallarg(fd_set *) ex;
	syscallarg(struct timeval *) tv;
};

struct sys_fsync_args {
	syscallarg(int) fd;
};

struct sys_setpriority_args {
	syscallarg(int) which;
	syscallarg(id_t) who;
	syscallarg(int) prio;
};

struct compat_30_sys_socket_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
};

struct sys_connect_args {
	syscallarg(int) s;
	syscallarg(const struct sockaddr *) name;
	syscallarg(unsigned int) namelen;
};

struct compat_43_sys_accept_args {
	syscallarg(int) s;
	syscallarg(caddr_t) name;
	syscallarg(int *) anamelen;
};

struct sys_getpriority_args {
	syscallarg(int) which;
	syscallarg(id_t) who;
};

struct compat_43_sys_send_args {
	syscallarg(int) s;
	syscallarg(caddr_t) buf;
	syscallarg(int) len;
	syscallarg(int) flags;
};

struct compat_43_sys_recv_args {
	syscallarg(int) s;
	syscallarg(caddr_t) buf;
	syscallarg(int) len;
	syscallarg(int) flags;
};

struct compat_13_sys_sigreturn_args {
	syscallarg(struct sigcontext13 *) sigcntxp;
};

struct sys_bind_args {
	syscallarg(int) s;
	syscallarg(const struct sockaddr *) name;
	syscallarg(unsigned int) namelen;
};

struct sys_setsockopt_args {
	syscallarg(int) s;
	syscallarg(int) level;
	syscallarg(int) name;
	syscallarg(const void *) val;
	syscallarg(unsigned int) valsize;
};

struct sys_listen_args {
	syscallarg(int) s;
	syscallarg(int) backlog;
};

struct compat_43_sys_sigvec_args {
	syscallarg(int) signum;
	syscallarg(struct sigvec *) nsv;
	syscallarg(struct sigvec *) osv;
};

struct compat_43_sys_sigblock_args {
	syscallarg(int) mask;
};

struct compat_43_sys_sigsetmask_args {
	syscallarg(int) mask;
};

struct compat_13_sys_sigsuspend_args {
	syscallarg(int) mask;
};

struct compat_43_sys_sigstack_args {
	syscallarg(struct sigstack *) nss;
	syscallarg(struct sigstack *) oss;
};

struct compat_43_sys_recvmsg_args {
	syscallarg(int) s;
	syscallarg(struct omsghdr *) msg;
	syscallarg(int) flags;
};

struct compat_43_sys_sendmsg_args {
	syscallarg(int) s;
	syscallarg(caddr_t) msg;
	syscallarg(int) flags;
};

struct sys_gettimeofday_args {
	syscallarg(struct timeval *) tp;
	syscallarg(void *) tzp;
};

struct sys_getrusage_args {
	syscallarg(int) who;
	syscallarg(struct rusage *) rusage;
};

struct sys_getsockopt_args {
	syscallarg(int) s;
	syscallarg(int) level;
	syscallarg(int) name;
	syscallarg(void *) val;
	syscallarg(unsigned int *) avalsize;
};

struct sys_readv_args {
	syscallarg(int) fd;
	syscallarg(const struct iovec *) iovp;
	syscallarg(int) iovcnt;
};

struct sys_writev_args {
	syscallarg(int) fd;
	syscallarg(const struct iovec *) iovp;
	syscallarg(int) iovcnt;
};

struct sys_settimeofday_args {
	syscallarg(const struct timeval *) tv;
	syscallarg(const void *) tzp;
};

struct sys_fchown_args {
	syscallarg(int) fd;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct sys_fchmod_args {
	syscallarg(int) fd;
	syscallarg(mode_t) mode;
};

struct compat_43_sys_recvfrom_args {
	syscallarg(int) s;
	syscallarg(caddr_t) buf;
	syscallarg(size_t) len;
	syscallarg(int) flags;
	syscallarg(caddr_t) from;
	syscallarg(int *) fromlenaddr;
};

struct sys_setreuid_args {
	syscallarg(uid_t) ruid;
	syscallarg(uid_t) euid;
};

struct sys_setregid_args {
	syscallarg(gid_t) rgid;
	syscallarg(gid_t) egid;
};

struct sys_rename_args {
	syscallarg(const char *) from;
	syscallarg(const char *) to;
};

struct compat_43_sys_truncate_args {
	syscallarg(const char *) path;
	syscallarg(long) length;
};

struct compat_43_sys_ftruncate_args {
	syscallarg(int) fd;
	syscallarg(long) length;
};

struct sys_flock_args {
	syscallarg(int) fd;
	syscallarg(int) how;
};

struct sys_mkfifo_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};

struct sys_sendto_args {
	syscallarg(int) s;
	syscallarg(const void *) buf;
	syscallarg(size_t) len;
	syscallarg(int) flags;
	syscallarg(const struct sockaddr *) to;
	syscallarg(unsigned int) tolen;
};

struct sys_shutdown_args {
	syscallarg(int) s;
	syscallarg(int) how;
};

struct sys_socketpair_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
	syscallarg(int *) rsv;
};

struct sys_mkdir_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};

struct sys_rmdir_args {
	syscallarg(const char *) path;
};

struct sys_utimes_args {
	syscallarg(const char *) path;
	syscallarg(const struct timeval *) tptr;
};

struct sys_adjtime_args {
	syscallarg(const struct timeval *) delta;
	syscallarg(struct timeval *) olddelta;
};

struct compat_43_sys_getpeername_args {
	syscallarg(int) fdes;
	syscallarg(caddr_t) asa;
	syscallarg(int *) alen;
};

struct compat_43_sys_sethostid_args {
	syscallarg(int32_t) hostid;
};

struct compat_43_sys_getrlimit_args {
	syscallarg(int) which;
	syscallarg(struct orlimit *) rlp;
};

struct compat_43_sys_setrlimit_args {
	syscallarg(int) which;
	syscallarg(const struct orlimit *) rlp;
};

struct compat_43_sys_killpg_args {
	syscallarg(int) pgid;
	syscallarg(int) signum;
};

struct sys_quotactl_args {
	syscallarg(const char *) path;
	syscallarg(int) cmd;
	syscallarg(int) uid;
	syscallarg(void *) arg;
};

struct compat_43_sys_getsockname_args {
	syscallarg(int) fdec;
	syscallarg(caddr_t) asa;
	syscallarg(int *) alen;
};
#if defined(NFS) || defined(NFSSERVER) || !defined(_KERNEL)

struct sys_nfssvc_args {
	syscallarg(int) flag;
	syscallarg(void *) argp;
};
#else
#endif

struct compat_43_sys_getdirentries_args {
	syscallarg(int) fd;
	syscallarg(char *) buf;
	syscallarg(u_int) count;
	syscallarg(long *) basep;
};

struct compat_20_sys_statfs_args {
	syscallarg(const char *) path;
	syscallarg(struct statfs12 *) buf;
};

struct compat_20_sys_fstatfs_args {
	syscallarg(int) fd;
	syscallarg(struct statfs12 *) buf;
};

struct compat_30_sys_getfh_args {
	syscallarg(const char *) fname;
	syscallarg(struct compat_30_fhandle *) fhp;
};

struct compat_09_sys_getdomainname_args {
	syscallarg(char *) domainname;
	syscallarg(int) len;
};

struct compat_09_sys_setdomainname_args {
	syscallarg(char *) domainname;
	syscallarg(int) len;
};

struct compat_09_sys_uname_args {
	syscallarg(struct outsname *) name;
};

struct sys_sysarch_args {
	syscallarg(int) op;
	syscallarg(void *) parms;
};
#if (defined(SYSVSEM) || !defined(_KERNEL)) && !defined(_LP64)

struct compat_10_sys_semsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
	syscallarg(int) a5;
};
#else
#endif
#if (defined(SYSVMSG) || !defined(_KERNEL)) && !defined(_LP64)

struct compat_10_sys_msgsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
	syscallarg(int) a5;
	syscallarg(int) a6;
};
#else
#endif
#if (defined(SYSVSHM) || !defined(_KERNEL)) && !defined(_LP64)

struct compat_10_sys_shmsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
};
#else
#endif

struct sys_pread_args {
	syscallarg(int) fd;
	syscallarg(void *) buf;
	syscallarg(size_t) nbyte;
	syscallarg(int) pad;
	syscallarg(off_t) offset;
};

struct sys_pwrite_args {
	syscallarg(int) fd;
	syscallarg(const void *) buf;
	syscallarg(size_t) nbyte;
	syscallarg(int) pad;
	syscallarg(off_t) offset;
};

struct compat_30_sys_ntp_gettime_args {
	syscallarg(struct ntptimeval30 *) ntvp;
};
#if defined(NTP) || !defined(_KERNEL)

struct sys_ntp_adjtime_args {
	syscallarg(struct timex *) tp;
};
#else
#endif

struct sys_setgid_args {
	syscallarg(gid_t) gid;
};

struct sys_setegid_args {
	syscallarg(gid_t) egid;
};

struct sys_seteuid_args {
	syscallarg(uid_t) euid;
};
#if defined(LFS) || !defined(_KERNEL)

struct sys_lfs_bmapv_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(struct block_info *) blkiov;
	syscallarg(int) blkcnt;
};

struct sys_lfs_markv_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(struct block_info *) blkiov;
	syscallarg(int) blkcnt;
};

struct sys_lfs_segclean_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(u_long) segment;
};

struct sys_lfs_segwait_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(struct timeval *) tv;
};
#else
#endif

struct compat_12_sys_stat_args {
	syscallarg(const char *) path;
	syscallarg(struct stat12 *) ub;
};

struct compat_12_sys_fstat_args {
	syscallarg(int) fd;
	syscallarg(struct stat12 *) sb;
};

struct compat_12_sys_lstat_args {
	syscallarg(const char *) path;
	syscallarg(struct stat12 *) ub;
};

struct sys_pathconf_args {
	syscallarg(const char *) path;
	syscallarg(int) name;
};

struct sys_fpathconf_args {
	syscallarg(int) fd;
	syscallarg(int) name;
};

struct sys_getrlimit_args {
	syscallarg(int) which;
	syscallarg(struct rlimit *) rlp;
};

struct sys_setrlimit_args {
	syscallarg(int) which;
	syscallarg(const struct rlimit *) rlp;
};

struct compat_12_sys_getdirentries_args {
	syscallarg(int) fd;
	syscallarg(char *) buf;
	syscallarg(u_int) count;
	syscallarg(long *) basep;
};

struct sys_mmap_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(long) pad;
	syscallarg(off_t) pos;
};

struct sys_lseek_args {
	syscallarg(int) fd;
	syscallarg(int) pad;
	syscallarg(off_t) offset;
	syscallarg(int) whence;
};

struct sys_truncate_args {
	syscallarg(const char *) path;
	syscallarg(int) pad;
	syscallarg(off_t) length;
};

struct sys_ftruncate_args {
	syscallarg(int) fd;
	syscallarg(int) pad;
	syscallarg(off_t) length;
};

struct sys___sysctl_args {
	syscallarg(const int *) name;
	syscallarg(u_int) namelen;
	syscallarg(void *) old;
	syscallarg(size_t *) oldlenp;
	syscallarg(const void *) new;
	syscallarg(size_t) newlen;
};

struct sys_mlock_args {
	syscallarg(const void *) addr;
	syscallarg(size_t) len;
};

struct sys_munlock_args {
	syscallarg(const void *) addr;
	syscallarg(size_t) len;
};

struct sys_undelete_args {
	syscallarg(const char *) path;
};

struct sys_futimes_args {
	syscallarg(int) fd;
	syscallarg(const struct timeval *) tptr;
};

struct sys_getpgid_args {
	syscallarg(pid_t) pid;
};

struct sys_reboot_args {
	syscallarg(int) opt;
	syscallarg(char *) bootstr;
};

struct sys_poll_args {
	syscallarg(struct pollfd *) fds;
	syscallarg(u_int) nfds;
	syscallarg(int) timeout;
};
#if defined(LKM) || !defined(_KERNEL)
#else	/* !LKM */
#endif	/* !LKM */
#if defined(SYSVSEM) || !defined(_KERNEL)

struct compat_14_sys___semctl_args {
	syscallarg(int) semid;
	syscallarg(int) semnum;
	syscallarg(int) cmd;
	syscallarg(union __semun *) arg;
};

struct sys_semget_args {
	syscallarg(key_t) key;
	syscallarg(int) nsems;
	syscallarg(int) semflg;
};

struct sys_semop_args {
	syscallarg(int) semid;
	syscallarg(struct sembuf *) sops;
	syscallarg(size_t) nsops;
};

struct sys_semconfig_args {
	syscallarg(int) flag;
};
#else
#endif
#if defined(SYSVMSG) || !defined(_KERNEL)

struct compat_14_sys_msgctl_args {
	syscallarg(int) msqid;
	syscallarg(int) cmd;
	syscallarg(struct msqid_ds14 *) buf;
};

struct sys_msgget_args {
	syscallarg(key_t) key;
	syscallarg(int) msgflg;
};

struct sys_msgsnd_args {
	syscallarg(int) msqid;
	syscallarg(const void *) msgp;
	syscallarg(size_t) msgsz;
	syscallarg(int) msgflg;
};

struct sys_msgrcv_args {
	syscallarg(int) msqid;
	syscallarg(void *) msgp;
	syscallarg(size_t) msgsz;
	syscallarg(long) msgtyp;
	syscallarg(int) msgflg;
};
#else
#endif
#if defined(SYSVSHM) || !defined(_KERNEL)

struct sys_shmat_args {
	syscallarg(int) shmid;
	syscallarg(const void *) shmaddr;
	syscallarg(int) shmflg;
};

struct compat_14_sys_shmctl_args {
	syscallarg(int) shmid;
	syscallarg(int) cmd;
	syscallarg(struct shmid_ds14 *) buf;
};

struct sys_shmdt_args {
	syscallarg(const void *) shmaddr;
};

struct sys_shmget_args {
	syscallarg(key_t) key;
	syscallarg(size_t) size;
	syscallarg(int) shmflg;
};
#else
#endif

struct sys_clock_gettime_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(struct timespec *) tp;
};

struct sys_clock_settime_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(const struct timespec *) tp;
};

struct sys_clock_getres_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(struct timespec *) tp;
};

struct sys_timer_create_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(struct sigevent *) evp;
	syscallarg(timer_t *) timerid;
};

struct sys_timer_delete_args {
	syscallarg(timer_t) timerid;
};

struct sys_timer_settime_args {
	syscallarg(timer_t) timerid;
	syscallarg(int) flags;
	syscallarg(const struct itimerspec *) value;
	syscallarg(struct itimerspec *) ovalue;
};

struct sys_timer_gettime_args {
	syscallarg(timer_t) timerid;
	syscallarg(struct itimerspec *) value;
};

struct sys_timer_getoverrun_args {
	syscallarg(timer_t) timerid;
};

struct sys_nanosleep_args {
	syscallarg(const struct timespec *) rqtp;
	syscallarg(struct timespec *) rmtp;
};

struct sys_fdatasync_args {
	syscallarg(int) fd;
};

struct sys_mlockall_args {
	syscallarg(int) flags;
};

struct sys___sigtimedwait_args {
	syscallarg(const sigset_t *) set;
	syscallarg(siginfo_t *) info;
	syscallarg(struct timespec *) timeout;
};
#if defined(P1003_1B_SEMAPHORE) || (!defined(_KERNEL) && defined(_LIBC))

struct sys__ksem_init_args {
	syscallarg(unsigned int) value;
	syscallarg(semid_t *) idp;
};

struct sys__ksem_open_args {
	syscallarg(const char *) name;
	syscallarg(int) oflag;
	syscallarg(mode_t) mode;
	syscallarg(unsigned int) value;
	syscallarg(semid_t *) idp;
};

struct sys__ksem_unlink_args {
	syscallarg(const char *) name;
};

struct sys__ksem_close_args {
	syscallarg(semid_t) id;
};

struct sys__ksem_post_args {
	syscallarg(semid_t) id;
};

struct sys__ksem_wait_args {
	syscallarg(semid_t) id;
};

struct sys__ksem_trywait_args {
	syscallarg(semid_t) id;
};

struct sys__ksem_getvalue_args {
	syscallarg(semid_t) id;
	syscallarg(unsigned int *) value;
};

struct sys__ksem_destroy_args {
	syscallarg(semid_t) id;
};
#else
#endif

struct sys___posix_rename_args {
	syscallarg(const char *) from;
	syscallarg(const char *) to;
};

struct sys_swapctl_args {
	syscallarg(int) cmd;
	syscallarg(void *) arg;
	syscallarg(int) misc;
};

struct compat_30_sys_getdents_args {
	syscallarg(int) fd;
	syscallarg(char *) buf;
	syscallarg(size_t) count;
};

struct sys_minherit_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) inherit;
};

struct sys_lchmod_args {
	syscallarg(const char *) path;
	syscallarg(mode_t) mode;
};

struct sys_lchown_args {
	syscallarg(const char *) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct sys_lutimes_args {
	syscallarg(const char *) path;
	syscallarg(const struct timeval *) tptr;
};

struct sys___msync13_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) flags;
};

struct compat_30_sys___stat13_args {
	syscallarg(const char *) path;
	syscallarg(struct stat13 *) ub;
};

struct compat_30_sys___fstat13_args {
	syscallarg(int) fd;
	syscallarg(struct stat13 *) sb;
};

struct compat_30_sys___lstat13_args {
	syscallarg(const char *) path;
	syscallarg(struct stat13 *) ub;
};

struct sys___sigaltstack14_args {
	syscallarg(const struct sigaltstack *) nss;
	syscallarg(struct sigaltstack *) oss;
};

struct sys___posix_chown_args {
	syscallarg(const char *) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct sys___posix_fchown_args {
	syscallarg(int) fd;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct sys___posix_lchown_args {
	syscallarg(const char *) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct sys_getsid_args {
	syscallarg(pid_t) pid;
};

struct sys___clone_args {
	syscallarg(int) flags;
	syscallarg(void *) stack;
};
#if defined(KTRACE) || !defined(_KERNEL)

struct sys_fktrace_args {
	syscallarg(const int) fd;
	syscallarg(int) ops;
	syscallarg(int) facs;
	syscallarg(int) pid;
};
#else
#endif

struct sys_preadv_args {
	syscallarg(int) fd;
	syscallarg(const struct iovec *) iovp;
	syscallarg(int) iovcnt;
	syscallarg(int) pad;
	syscallarg(off_t) offset;
};

struct sys_pwritev_args {
	syscallarg(int) fd;
	syscallarg(const struct iovec *) iovp;
	syscallarg(int) iovcnt;
	syscallarg(int) pad;
	syscallarg(off_t) offset;
};

struct compat_16_sys___sigaction14_args {
	syscallarg(int) signum;
	syscallarg(const struct sigaction *) nsa;
	syscallarg(struct sigaction *) osa;
};

struct sys___sigpending14_args {
	syscallarg(sigset_t *) set;
};

struct sys___sigprocmask14_args {
	syscallarg(int) how;
	syscallarg(const sigset_t *) set;
	syscallarg(sigset_t *) oset;
};

struct sys___sigsuspend14_args {
	syscallarg(const sigset_t *) set;
};

struct compat_16_sys___sigreturn14_args {
	syscallarg(struct sigcontext *) sigcntxp;
};

struct sys___getcwd_args {
	syscallarg(char *) bufp;
	syscallarg(size_t) length;
};

struct sys_fchroot_args {
	syscallarg(int) fd;
};

struct compat_30_sys_fhopen_args {
	syscallarg(const struct compat_30_fhandle *) fhp;
	syscallarg(int) flags;
};

struct compat_30_sys_fhstat_args {
	syscallarg(const struct compat_30_fhandle *) fhp;
	syscallarg(struct stat13 *) sb;
};

struct compat_20_sys_fhstatfs_args {
	syscallarg(const struct compat_30_fhandle *) fhp;
	syscallarg(struct statfs12 *) buf;
};
#if defined(SYSVSEM) || !defined(_KERNEL)

struct sys_____semctl13_args {
	syscallarg(int) semid;
	syscallarg(int) semnum;
	syscallarg(int) cmd;
	syscallarg(union __semun *) arg;
};
#else
#endif
#if defined(SYSVMSG) || !defined(_KERNEL)

struct sys___msgctl13_args {
	syscallarg(int) msqid;
	syscallarg(int) cmd;
	syscallarg(struct msqid_ds *) buf;
};
#else
#endif
#if defined(SYSVSHM) || !defined(_KERNEL)

struct sys___shmctl13_args {
	syscallarg(int) shmid;
	syscallarg(int) cmd;
	syscallarg(struct shmid_ds *) buf;
};
#else
#endif

struct sys_lchflags_args {
	syscallarg(const char *) path;
	syscallarg(u_long) flags;
};

struct sys_utrace_args {
	syscallarg(const char *) label;
	syscallarg(void *) addr;
	syscallarg(size_t) len;
};

struct sys_getcontext_args {
	syscallarg(struct __ucontext *) ucp;
};

struct sys_setcontext_args {
	syscallarg(const struct __ucontext *) ucp;
};

struct sys__lwp_create_args {
	syscallarg(const struct __ucontext *) ucp;
	syscallarg(u_long) flags;
	syscallarg(lwpid_t *) new_lwp;
};

struct sys__lwp_wait_args {
	syscallarg(lwpid_t) wait_for;
	syscallarg(lwpid_t *) departed;
};

struct sys__lwp_suspend_args {
	syscallarg(lwpid_t) target;
};

struct sys__lwp_continue_args {
	syscallarg(lwpid_t) target;
};

struct sys__lwp_wakeup_args {
	syscallarg(lwpid_t) target;
};

struct sys__lwp_setprivate_args {
	syscallarg(void *) ptr;
};

struct sys_sa_register_args {
	syscallarg(sa_upcall_t) new;
	syscallarg(sa_upcall_t *) old;
	syscallarg(int) flags;
	syscallarg(ssize_t) stackinfo_offset;
};

struct sys_sa_stacks_args {
	syscallarg(int) num;
	syscallarg(stack_t *) stacks;
};

struct sys_sa_setconcurrency_args {
	syscallarg(int) concurrency;
};

struct sys_sa_preempt_args {
	syscallarg(int) sa_id;
};

struct sys___sigaction_sigtramp_args {
	syscallarg(int) signum;
	syscallarg(const struct sigaction *) nsa;
	syscallarg(struct sigaction *) osa;
	syscallarg(const void *) tramp;
	syscallarg(int) vers;
};

struct sys_pmc_get_info_args {
	syscallarg(int) ctr;
	syscallarg(int) op;
	syscallarg(void *) args;
};

struct sys_pmc_control_args {
	syscallarg(int) ctr;
	syscallarg(int) op;
	syscallarg(void *) args;
};

struct sys_rasctl_args {
	syscallarg(caddr_t) addr;
	syscallarg(size_t) len;
	syscallarg(int) op;
};

struct sys_kevent_args {
	syscallarg(int) fd;
	syscallarg(const struct kevent *) changelist;
	syscallarg(size_t) nchanges;
	syscallarg(struct kevent *) eventlist;
	syscallarg(size_t) nevents;
	syscallarg(const struct timespec *) timeout;
};

struct sys_fsync_range_args {
	syscallarg(int) fd;
	syscallarg(int) flags;
	syscallarg(off_t) start;
	syscallarg(off_t) length;
};

struct sys_uuidgen_args {
	syscallarg(struct uuid *) store;
	syscallarg(int) count;
};

struct sys_getvfsstat_args {
	syscallarg(struct statvfs *) buf;
	syscallarg(size_t) bufsize;
	syscallarg(int) flags;
};

struct sys_statvfs1_args {
	syscallarg(const char *) path;
	syscallarg(struct statvfs *) buf;
	syscallarg(int) flags;
};

struct sys_fstatvfs1_args {
	syscallarg(int) fd;
	syscallarg(struct statvfs *) buf;
	syscallarg(int) flags;
};

struct compat_30_sys_fhstatvfs1_args {
	syscallarg(const struct compat_30_fhandle *) fhp;
	syscallarg(struct statvfs *) buf;
	syscallarg(int) flags;
};

struct sys_extattrctl_args {
	syscallarg(const char *) path;
	syscallarg(int) cmd;
	syscallarg(const char *) filename;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
};

struct sys_extattr_set_file_args {
	syscallarg(const char *) path;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
	syscallarg(const void *) data;
	syscallarg(size_t) nbytes;
};

struct sys_extattr_get_file_args {
	syscallarg(const char *) path;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
	syscallarg(void *) data;
	syscallarg(size_t) nbytes;
};

struct sys_extattr_delete_file_args {
	syscallarg(const char *) path;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
};

struct sys_extattr_set_fd_args {
	syscallarg(int) fd;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
	syscallarg(const void *) data;
	syscallarg(size_t) nbytes;
};

struct sys_extattr_get_fd_args {
	syscallarg(int) fd;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
	syscallarg(void *) data;
	syscallarg(size_t) nbytes;
};

struct sys_extattr_delete_fd_args {
	syscallarg(int) fd;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
};

struct sys_extattr_set_link_args {
	syscallarg(const char *) path;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
	syscallarg(const void *) data;
	syscallarg(size_t) nbytes;
};

struct sys_extattr_get_link_args {
	syscallarg(const char *) path;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
	syscallarg(void *) data;
	syscallarg(size_t) nbytes;
};

struct sys_extattr_delete_link_args {
	syscallarg(const char *) path;
	syscallarg(int) attrnamespace;
	syscallarg(const char *) attrname;
};

struct sys_extattr_list_fd_args {
	syscallarg(int) fd;
	syscallarg(int) attrnamespace;
	syscallarg(void *) data;
	syscallarg(size_t) nbytes;
};

struct sys_extattr_list_file_args {
	syscallarg(const char *) path;
	syscallarg(int) attrnamespace;
	syscallarg(void *) data;
	syscallarg(size_t) nbytes;
};

struct sys_extattr_list_link_args {
	syscallarg(const char *) path;
	syscallarg(int) attrnamespace;
	syscallarg(void *) data;
	syscallarg(size_t) nbytes;
};

struct sys_pselect_args {
	syscallarg(int) nd;
	syscallarg(fd_set *) in;
	syscallarg(fd_set *) ou;
	syscallarg(fd_set *) ex;
	syscallarg(const struct timespec *) ts;
	syscallarg(const sigset_t *) mask;
};

struct sys_pollts_args {
	syscallarg(struct pollfd *) fds;
	syscallarg(u_int) nfds;
	syscallarg(const struct timespec *) ts;
	syscallarg(const sigset_t *) mask;
};

struct sys_setxattr_args {
	syscallarg(const char *) path;
	syscallarg(const char *) name;
	syscallarg(void *) value;
	syscallarg(size_t) size;
	syscallarg(int) flags;
};

struct sys_lsetxattr_args {
	syscallarg(const char *) path;
	syscallarg(const char *) name;
	syscallarg(void *) value;
	syscallarg(size_t) size;
	syscallarg(int) flags;
};

struct sys_fsetxattr_args {
	syscallarg(int) fd;
	syscallarg(const char *) name;
	syscallarg(void *) value;
	syscallarg(size_t) size;
	syscallarg(int) flags;
};

struct sys_getxattr_args {
	syscallarg(const char *) path;
	syscallarg(const char *) name;
	syscallarg(void *) value;
	syscallarg(size_t) size;
};

struct sys_lgetxattr_args {
	syscallarg(const char *) path;
	syscallarg(const char *) name;
	syscallarg(void *) value;
	syscallarg(size_t) size;
};

struct sys_fgetxattr_args {
	syscallarg(int) fd;
	syscallarg(const char *) name;
	syscallarg(void *) value;
	syscallarg(size_t) size;
};

struct sys_listxattr_args {
	syscallarg(const char *) path;
	syscallarg(char *) list;
	syscallarg(size_t) size;
};

struct sys_llistxattr_args {
	syscallarg(const char *) path;
	syscallarg(char *) list;
	syscallarg(size_t) size;
};

struct sys_flistxattr_args {
	syscallarg(int) fd;
	syscallarg(char *) list;
	syscallarg(size_t) size;
};

struct sys_removexattr_args {
	syscallarg(const char *) path;
	syscallarg(const char *) name;
};

struct sys_lremovexattr_args {
	syscallarg(const char *) path;
	syscallarg(const char *) name;
};

struct sys_fremovexattr_args {
	syscallarg(int) fd;
	syscallarg(const char *) name;
};

struct sys___stat30_args {
	syscallarg(const char *) path;
	syscallarg(struct stat *) ub;
};

struct sys___fstat30_args {
	syscallarg(int) fd;
	syscallarg(struct stat *) sb;
};

struct sys___lstat30_args {
	syscallarg(const char *) path;
	syscallarg(struct stat *) ub;
};

struct sys___getdents30_args {
	syscallarg(int) fd;
	syscallarg(char *) buf;
	syscallarg(size_t) count;
};

struct sys_posix_fadvise_args {
	syscallarg(int) fd;
	syscallarg(off_t) offset;
	syscallarg(off_t) len;
	syscallarg(int) advice;
};

struct compat_30_sys___fhstat30_args {
	syscallarg(const struct compat_30_fhandle *) fhp;
	syscallarg(struct stat *) sb;
};

struct sys___ntp_gettime30_args {
	syscallarg(struct ntptimeval *) ntvp;
};

struct sys___socket30_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
};

struct sys___getfh30_args {
	syscallarg(const char *) fname;
	syscallarg(void *) fhp;
	syscallarg(size_t *) fh_size;
};

struct sys___fhopen40_args {
	syscallarg(const void *) fhp;
	syscallarg(size_t) fh_size;
	syscallarg(int) flags;
};

struct sys___fhstatvfs140_args {
	syscallarg(const void *) fhp;
	syscallarg(size_t) fh_size;
	syscallarg(struct statvfs *) buf;
	syscallarg(int) flags;
};

struct sys___fhstat40_args {
	syscallarg(const void *) fhp;
	syscallarg(size_t) fh_size;
	syscallarg(struct stat *) sb;
};

/*
 * System call prototypes.
 */

int	sys_exit(struct lwp *, void *, register_t *);

int	sys_fork(struct lwp *, void *, register_t *);

int	sys_read(struct lwp *, void *, register_t *);

int	sys_write(struct lwp *, void *, register_t *);

int	sys_open(struct lwp *, void *, register_t *);

int	sys_close(struct lwp *, void *, register_t *);

int	sys_wait4(struct lwp *, void *, register_t *);

int	compat_43_sys_creat(struct lwp *, void *, register_t *);

int	sys_link(struct lwp *, void *, register_t *);

int	sys_unlink(struct lwp *, void *, register_t *);

int	sys_chdir(struct lwp *, void *, register_t *);

int	sys_fchdir(struct lwp *, void *, register_t *);

int	sys_mknod(struct lwp *, void *, register_t *);

int	sys_chmod(struct lwp *, void *, register_t *);

int	sys_chown(struct lwp *, void *, register_t *);

int	sys_obreak(struct lwp *, void *, register_t *);

int	compat_20_sys_getfsstat(struct lwp *, void *, register_t *);

int	compat_43_sys_lseek(struct lwp *, void *, register_t *);

#ifdef COMPAT_43
int	sys_getpid_with_ppid(struct lwp *, void *, register_t *);

#else
int	sys_getpid(struct lwp *, void *, register_t *);

#endif
int	sys_mount(struct lwp *, void *, register_t *);

int	sys_unmount(struct lwp *, void *, register_t *);

int	sys_setuid(struct lwp *, void *, register_t *);

#ifdef COMPAT_43
int	sys_getuid_with_euid(struct lwp *, void *, register_t *);

#else
int	sys_getuid(struct lwp *, void *, register_t *);

#endif
int	sys_geteuid(struct lwp *, void *, register_t *);

int	sys_ptrace(struct lwp *, void *, register_t *);

int	sys_recvmsg(struct lwp *, void *, register_t *);

int	sys_sendmsg(struct lwp *, void *, register_t *);

int	sys_recvfrom(struct lwp *, void *, register_t *);

int	sys_accept(struct lwp *, void *, register_t *);

int	sys_getpeername(struct lwp *, void *, register_t *);

int	sys_getsockname(struct lwp *, void *, register_t *);

int	sys_access(struct lwp *, void *, register_t *);

int	sys_chflags(struct lwp *, void *, register_t *);

int	sys_fchflags(struct lwp *, void *, register_t *);

int	sys_sync(struct lwp *, void *, register_t *);

int	sys_kill(struct lwp *, void *, register_t *);

int	compat_43_sys_stat(struct lwp *, void *, register_t *);

int	sys_getppid(struct lwp *, void *, register_t *);

int	compat_43_sys_lstat(struct lwp *, void *, register_t *);

int	sys_dup(struct lwp *, void *, register_t *);

int	sys_pipe(struct lwp *, void *, register_t *);

int	sys_getegid(struct lwp *, void *, register_t *);

int	sys_profil(struct lwp *, void *, register_t *);

#if defined(KTRACE) || !defined(_KERNEL)
int	sys_ktrace(struct lwp *, void *, register_t *);

#else
#endif
int	compat_13_sys_sigaction(struct lwp *, void *, register_t *);

#ifdef COMPAT_43
int	sys_getgid_with_egid(struct lwp *, void *, register_t *);

#else
int	sys_getgid(struct lwp *, void *, register_t *);

#endif
int	compat_13_sys_sigprocmask(struct lwp *, void *, register_t *);

int	sys___getlogin(struct lwp *, void *, register_t *);

int	sys___setlogin(struct lwp *, void *, register_t *);

int	sys_acct(struct lwp *, void *, register_t *);

int	compat_13_sys_sigpending(struct lwp *, void *, register_t *);

int	compat_13_sys_sigaltstack(struct lwp *, void *, register_t *);

int	sys_ioctl(struct lwp *, void *, register_t *);

int	compat_12_sys_reboot(struct lwp *, void *, register_t *);

int	sys_revoke(struct lwp *, void *, register_t *);

int	sys_symlink(struct lwp *, void *, register_t *);

int	sys_readlink(struct lwp *, void *, register_t *);

int	sys_execve(struct lwp *, void *, register_t *);

int	sys_umask(struct lwp *, void *, register_t *);

int	sys_chroot(struct lwp *, void *, register_t *);

int	compat_43_sys_fstat(struct lwp *, void *, register_t *);

int	compat_43_sys_getkerninfo(struct lwp *, void *, register_t *);

int	compat_43_sys_getpagesize(struct lwp *, void *, register_t *);

int	compat_12_sys_msync(struct lwp *, void *, register_t *);

int	sys_vfork(struct lwp *, void *, register_t *);

int	sys_sbrk(struct lwp *, void *, register_t *);

int	sys_sstk(struct lwp *, void *, register_t *);

int	compat_43_sys_mmap(struct lwp *, void *, register_t *);

int	sys_ovadvise(struct lwp *, void *, register_t *);

int	sys_munmap(struct lwp *, void *, register_t *);

int	sys_mprotect(struct lwp *, void *, register_t *);

int	sys_madvise(struct lwp *, void *, register_t *);

int	sys_mincore(struct lwp *, void *, register_t *);

int	sys_getgroups(struct lwp *, void *, register_t *);

int	sys_setgroups(struct lwp *, void *, register_t *);

int	sys_getpgrp(struct lwp *, void *, register_t *);

int	sys_setpgid(struct lwp *, void *, register_t *);

int	sys_setitimer(struct lwp *, void *, register_t *);

int	compat_43_sys_wait(struct lwp *, void *, register_t *);

int	compat_12_sys_swapon(struct lwp *, void *, register_t *);

int	sys_getitimer(struct lwp *, void *, register_t *);

int	compat_43_sys_gethostname(struct lwp *, void *, register_t *);

int	compat_43_sys_sethostname(struct lwp *, void *, register_t *);

int	compat_43_sys_getdtablesize(struct lwp *, void *, register_t *);

int	sys_dup2(struct lwp *, void *, register_t *);

int	sys_fcntl(struct lwp *, void *, register_t *);

int	sys_select(struct lwp *, void *, register_t *);

int	sys_fsync(struct lwp *, void *, register_t *);

int	sys_setpriority(struct lwp *, void *, register_t *);

int	compat_30_sys_socket(struct lwp *, void *, register_t *);

int	sys_connect(struct lwp *, void *, register_t *);

int	compat_43_sys_accept(struct lwp *, void *, register_t *);

int	sys_getpriority(struct lwp *, void *, register_t *);

int	compat_43_sys_send(struct lwp *, void *, register_t *);

int	compat_43_sys_recv(struct lwp *, void *, register_t *);

int	compat_13_sys_sigreturn(struct lwp *, void *, register_t *);

int	sys_bind(struct lwp *, void *, register_t *);

int	sys_setsockopt(struct lwp *, void *, register_t *);

int	sys_listen(struct lwp *, void *, register_t *);

int	compat_43_sys_sigvec(struct lwp *, void *, register_t *);

int	compat_43_sys_sigblock(struct lwp *, void *, register_t *);

int	compat_43_sys_sigsetmask(struct lwp *, void *, register_t *);

int	compat_13_sys_sigsuspend(struct lwp *, void *, register_t *);

int	compat_43_sys_sigstack(struct lwp *, void *, register_t *);

int	compat_43_sys_recvmsg(struct lwp *, void *, register_t *);

int	compat_43_sys_sendmsg(struct lwp *, void *, register_t *);

int	sys_gettimeofday(struct lwp *, void *, register_t *);

int	sys_getrusage(struct lwp *, void *, register_t *);

int	sys_getsockopt(struct lwp *, void *, register_t *);

int	sys_readv(struct lwp *, void *, register_t *);

int	sys_writev(struct lwp *, void *, register_t *);

int	sys_settimeofday(struct lwp *, void *, register_t *);

int	sys_fchown(struct lwp *, void *, register_t *);

int	sys_fchmod(struct lwp *, void *, register_t *);

int	compat_43_sys_recvfrom(struct lwp *, void *, register_t *);

int	sys_setreuid(struct lwp *, void *, register_t *);

int	sys_setregid(struct lwp *, void *, register_t *);

int	sys_rename(struct lwp *, void *, register_t *);

int	compat_43_sys_truncate(struct lwp *, void *, register_t *);

int	compat_43_sys_ftruncate(struct lwp *, void *, register_t *);

int	sys_flock(struct lwp *, void *, register_t *);

int	sys_mkfifo(struct lwp *, void *, register_t *);

int	sys_sendto(struct lwp *, void *, register_t *);

int	sys_shutdown(struct lwp *, void *, register_t *);

int	sys_socketpair(struct lwp *, void *, register_t *);

int	sys_mkdir(struct lwp *, void *, register_t *);

int	sys_rmdir(struct lwp *, void *, register_t *);

int	sys_utimes(struct lwp *, void *, register_t *);

int	sys_adjtime(struct lwp *, void *, register_t *);

int	compat_43_sys_getpeername(struct lwp *, void *, register_t *);

int	compat_43_sys_gethostid(struct lwp *, void *, register_t *);

int	compat_43_sys_sethostid(struct lwp *, void *, register_t *);

int	compat_43_sys_getrlimit(struct lwp *, void *, register_t *);

int	compat_43_sys_setrlimit(struct lwp *, void *, register_t *);

int	compat_43_sys_killpg(struct lwp *, void *, register_t *);

int	sys_setsid(struct lwp *, void *, register_t *);

int	sys_quotactl(struct lwp *, void *, register_t *);

int	compat_43_sys_quota(struct lwp *, void *, register_t *);

int	compat_43_sys_getsockname(struct lwp *, void *, register_t *);

#if defined(NFS) || defined(NFSSERVER) || !defined(_KERNEL)
int	sys_nfssvc(struct lwp *, void *, register_t *);

#else
#endif
int	compat_43_sys_getdirentries(struct lwp *, void *, register_t *);

int	compat_20_sys_statfs(struct lwp *, void *, register_t *);

int	compat_20_sys_fstatfs(struct lwp *, void *, register_t *);

int	compat_30_sys_getfh(struct lwp *, void *, register_t *);

int	compat_09_sys_getdomainname(struct lwp *, void *, register_t *);

int	compat_09_sys_setdomainname(struct lwp *, void *, register_t *);

int	compat_09_sys_uname(struct lwp *, void *, register_t *);

int	sys_sysarch(struct lwp *, void *, register_t *);

#if (defined(SYSVSEM) || !defined(_KERNEL)) && !defined(_LP64)
int	compat_10_sys_semsys(struct lwp *, void *, register_t *);

#else
#endif
#if (defined(SYSVMSG) || !defined(_KERNEL)) && !defined(_LP64)
int	compat_10_sys_msgsys(struct lwp *, void *, register_t *);

#else
#endif
#if (defined(SYSVSHM) || !defined(_KERNEL)) && !defined(_LP64)
int	compat_10_sys_shmsys(struct lwp *, void *, register_t *);

#else
#endif
int	sys_pread(struct lwp *, void *, register_t *);

int	sys_pwrite(struct lwp *, void *, register_t *);

int	compat_30_sys_ntp_gettime(struct lwp *, void *, register_t *);

#if defined(NTP) || !defined(_KERNEL)
int	sys_ntp_adjtime(struct lwp *, void *, register_t *);

#else
#endif
int	sys_setgid(struct lwp *, void *, register_t *);

int	sys_setegid(struct lwp *, void *, register_t *);

int	sys_seteuid(struct lwp *, void *, register_t *);

#if defined(LFS) || !defined(_KERNEL)
int	sys_lfs_bmapv(struct lwp *, void *, register_t *);

int	sys_lfs_markv(struct lwp *, void *, register_t *);

int	sys_lfs_segclean(struct lwp *, void *, register_t *);

int	sys_lfs_segwait(struct lwp *, void *, register_t *);

#else
#endif
int	compat_12_sys_stat(struct lwp *, void *, register_t *);

int	compat_12_sys_fstat(struct lwp *, void *, register_t *);

int	compat_12_sys_lstat(struct lwp *, void *, register_t *);

int	sys_pathconf(struct lwp *, void *, register_t *);

int	sys_fpathconf(struct lwp *, void *, register_t *);

int	sys_getrlimit(struct lwp *, void *, register_t *);

int	sys_setrlimit(struct lwp *, void *, register_t *);

int	compat_12_sys_getdirentries(struct lwp *, void *, register_t *);

int	sys_mmap(struct lwp *, void *, register_t *);

int	sys_lseek(struct lwp *, void *, register_t *);

int	sys_truncate(struct lwp *, void *, register_t *);

int	sys_ftruncate(struct lwp *, void *, register_t *);

int	sys___sysctl(struct lwp *, void *, register_t *);

int	sys_mlock(struct lwp *, void *, register_t *);

int	sys_munlock(struct lwp *, void *, register_t *);

int	sys_undelete(struct lwp *, void *, register_t *);

int	sys_futimes(struct lwp *, void *, register_t *);

int	sys_getpgid(struct lwp *, void *, register_t *);

int	sys_reboot(struct lwp *, void *, register_t *);

int	sys_poll(struct lwp *, void *, register_t *);

#if defined(LKM) || !defined(_KERNEL)
int	sys_lkmnosys(struct lwp *, void *, register_t *);

#else	/* !LKM */
#endif	/* !LKM */
#if defined(SYSVSEM) || !defined(_KERNEL)
int	compat_14_sys___semctl(struct lwp *, void *, register_t *);

int	sys_semget(struct lwp *, void *, register_t *);

int	sys_semop(struct lwp *, void *, register_t *);

int	sys_semconfig(struct lwp *, void *, register_t *);

#else
#endif
#if defined(SYSVMSG) || !defined(_KERNEL)
int	compat_14_sys_msgctl(struct lwp *, void *, register_t *);

int	sys_msgget(struct lwp *, void *, register_t *);

int	sys_msgsnd(struct lwp *, void *, register_t *);

int	sys_msgrcv(struct lwp *, void *, register_t *);

#else
#endif
#if defined(SYSVSHM) || !defined(_KERNEL)
int	sys_shmat(struct lwp *, void *, register_t *);

int	compat_14_sys_shmctl(struct lwp *, void *, register_t *);

int	sys_shmdt(struct lwp *, void *, register_t *);

int	sys_shmget(struct lwp *, void *, register_t *);

#else
#endif
int	sys_clock_gettime(struct lwp *, void *, register_t *);

int	sys_clock_settime(struct lwp *, void *, register_t *);

int	sys_clock_getres(struct lwp *, void *, register_t *);

int	sys_timer_create(struct lwp *, void *, register_t *);

int	sys_timer_delete(struct lwp *, void *, register_t *);

int	sys_timer_settime(struct lwp *, void *, register_t *);

int	sys_timer_gettime(struct lwp *, void *, register_t *);

int	sys_timer_getoverrun(struct lwp *, void *, register_t *);

int	sys_nanosleep(struct lwp *, void *, register_t *);

int	sys_fdatasync(struct lwp *, void *, register_t *);

int	sys_mlockall(struct lwp *, void *, register_t *);

int	sys_munlockall(struct lwp *, void *, register_t *);

int	sys___sigtimedwait(struct lwp *, void *, register_t *);

#if defined(P1003_1B_SEMAPHORE) || (!defined(_KERNEL) && defined(_LIBC))
int	sys__ksem_init(struct lwp *, void *, register_t *);

int	sys__ksem_open(struct lwp *, void *, register_t *);

int	sys__ksem_unlink(struct lwp *, void *, register_t *);

int	sys__ksem_close(struct lwp *, void *, register_t *);

int	sys__ksem_post(struct lwp *, void *, register_t *);

int	sys__ksem_wait(struct lwp *, void *, register_t *);

int	sys__ksem_trywait(struct lwp *, void *, register_t *);

int	sys__ksem_getvalue(struct lwp *, void *, register_t *);

int	sys__ksem_destroy(struct lwp *, void *, register_t *);

#else
#endif
int	sys___posix_rename(struct lwp *, void *, register_t *);

int	sys_swapctl(struct lwp *, void *, register_t *);

int	compat_30_sys_getdents(struct lwp *, void *, register_t *);

int	sys_minherit(struct lwp *, void *, register_t *);

int	sys_lchmod(struct lwp *, void *, register_t *);

int	sys_lchown(struct lwp *, void *, register_t *);

int	sys_lutimes(struct lwp *, void *, register_t *);

int	sys___msync13(struct lwp *, void *, register_t *);

int	compat_30_sys___stat13(struct lwp *, void *, register_t *);

int	compat_30_sys___fstat13(struct lwp *, void *, register_t *);

int	compat_30_sys___lstat13(struct lwp *, void *, register_t *);

int	sys___sigaltstack14(struct lwp *, void *, register_t *);

int	sys___vfork14(struct lwp *, void *, register_t *);

int	sys___posix_chown(struct lwp *, void *, register_t *);

int	sys___posix_fchown(struct lwp *, void *, register_t *);

int	sys___posix_lchown(struct lwp *, void *, register_t *);

int	sys_getsid(struct lwp *, void *, register_t *);

int	sys___clone(struct lwp *, void *, register_t *);

#if defined(KTRACE) || !defined(_KERNEL)
int	sys_fktrace(struct lwp *, void *, register_t *);

#else
#endif
int	sys_preadv(struct lwp *, void *, register_t *);

int	sys_pwritev(struct lwp *, void *, register_t *);

int	compat_16_sys___sigaction14(struct lwp *, void *, register_t *);

int	sys___sigpending14(struct lwp *, void *, register_t *);

int	sys___sigprocmask14(struct lwp *, void *, register_t *);

int	sys___sigsuspend14(struct lwp *, void *, register_t *);

int	compat_16_sys___sigreturn14(struct lwp *, void *, register_t *);

int	sys___getcwd(struct lwp *, void *, register_t *);

int	sys_fchroot(struct lwp *, void *, register_t *);

int	compat_30_sys_fhopen(struct lwp *, void *, register_t *);

int	compat_30_sys_fhstat(struct lwp *, void *, register_t *);

int	compat_20_sys_fhstatfs(struct lwp *, void *, register_t *);

#if defined(SYSVSEM) || !defined(_KERNEL)
int	sys_____semctl13(struct lwp *, void *, register_t *);

#else
#endif
#if defined(SYSVMSG) || !defined(_KERNEL)
int	sys___msgctl13(struct lwp *, void *, register_t *);

#else
#endif
#if defined(SYSVSHM) || !defined(_KERNEL)
int	sys___shmctl13(struct lwp *, void *, register_t *);

#else
#endif
int	sys_lchflags(struct lwp *, void *, register_t *);

int	sys_issetugid(struct lwp *, void *, register_t *);

int	sys_utrace(struct lwp *, void *, register_t *);

int	sys_getcontext(struct lwp *, void *, register_t *);

int	sys_setcontext(struct lwp *, void *, register_t *);

int	sys__lwp_create(struct lwp *, void *, register_t *);

int	sys__lwp_exit(struct lwp *, void *, register_t *);

int	sys__lwp_self(struct lwp *, void *, register_t *);

int	sys__lwp_wait(struct lwp *, void *, register_t *);

int	sys__lwp_suspend(struct lwp *, void *, register_t *);

int	sys__lwp_continue(struct lwp *, void *, register_t *);

int	sys__lwp_wakeup(struct lwp *, void *, register_t *);

int	sys__lwp_getprivate(struct lwp *, void *, register_t *);

int	sys__lwp_setprivate(struct lwp *, void *, register_t *);

int	sys_sa_register(struct lwp *, void *, register_t *);

int	sys_sa_stacks(struct lwp *, void *, register_t *);

int	sys_sa_enable(struct lwp *, void *, register_t *);

int	sys_sa_setconcurrency(struct lwp *, void *, register_t *);

int	sys_sa_yield(struct lwp *, void *, register_t *);

int	sys_sa_preempt(struct lwp *, void *, register_t *);

int	sys___sigaction_sigtramp(struct lwp *, void *, register_t *);

int	sys_pmc_get_info(struct lwp *, void *, register_t *);

int	sys_pmc_control(struct lwp *, void *, register_t *);

int	sys_rasctl(struct lwp *, void *, register_t *);

int	sys_kqueue(struct lwp *, void *, register_t *);

int	sys_kevent(struct lwp *, void *, register_t *);

int	sys_fsync_range(struct lwp *, void *, register_t *);

int	sys_uuidgen(struct lwp *, void *, register_t *);

int	sys_getvfsstat(struct lwp *, void *, register_t *);

int	sys_statvfs1(struct lwp *, void *, register_t *);

int	sys_fstatvfs1(struct lwp *, void *, register_t *);

int	compat_30_sys_fhstatvfs1(struct lwp *, void *, register_t *);

int	sys_extattrctl(struct lwp *, void *, register_t *);

int	sys_extattr_set_file(struct lwp *, void *, register_t *);

int	sys_extattr_get_file(struct lwp *, void *, register_t *);

int	sys_extattr_delete_file(struct lwp *, void *, register_t *);

int	sys_extattr_set_fd(struct lwp *, void *, register_t *);

int	sys_extattr_get_fd(struct lwp *, void *, register_t *);

int	sys_extattr_delete_fd(struct lwp *, void *, register_t *);

int	sys_extattr_set_link(struct lwp *, void *, register_t *);

int	sys_extattr_get_link(struct lwp *, void *, register_t *);

int	sys_extattr_delete_link(struct lwp *, void *, register_t *);

int	sys_extattr_list_fd(struct lwp *, void *, register_t *);

int	sys_extattr_list_file(struct lwp *, void *, register_t *);

int	sys_extattr_list_link(struct lwp *, void *, register_t *);

int	sys_pselect(struct lwp *, void *, register_t *);

int	sys_pollts(struct lwp *, void *, register_t *);

int	sys_setxattr(struct lwp *, void *, register_t *);

int	sys_lsetxattr(struct lwp *, void *, register_t *);

int	sys_fsetxattr(struct lwp *, void *, register_t *);

int	sys_getxattr(struct lwp *, void *, register_t *);

int	sys_lgetxattr(struct lwp *, void *, register_t *);

int	sys_fgetxattr(struct lwp *, void *, register_t *);

int	sys_listxattr(struct lwp *, void *, register_t *);

int	sys_llistxattr(struct lwp *, void *, register_t *);

int	sys_flistxattr(struct lwp *, void *, register_t *);

int	sys_removexattr(struct lwp *, void *, register_t *);

int	sys_lremovexattr(struct lwp *, void *, register_t *);

int	sys_fremovexattr(struct lwp *, void *, register_t *);

int	sys___stat30(struct lwp *, void *, register_t *);

int	sys___fstat30(struct lwp *, void *, register_t *);

int	sys___lstat30(struct lwp *, void *, register_t *);

int	sys___getdents30(struct lwp *, void *, register_t *);

int	sys_posix_fadvise(struct lwp *, void *, register_t *);

int	compat_30_sys___fhstat30(struct lwp *, void *, register_t *);

int	sys___ntp_gettime30(struct lwp *, void *, register_t *);

int	sys___socket30(struct lwp *, void *, register_t *);

int	sys___getfh30(struct lwp *, void *, register_t *);

int	sys___fhopen40(struct lwp *, void *, register_t *);

int	sys___fhstatvfs140(struct lwp *, void *, register_t *);

int	sys___fhstat40(struct lwp *, void *, register_t *);

#endif /* _SYS_SYSCALLARGS_H_ */
